## Description of files in the repository
* models.py contain the code for building the models used in the experiment. 
It is built around an abstract class ProjectNet, which is instantiated for the three different group. 
The ProjectNet stores a number of layers and a method for projecting all layers (and gradients) onto the space E.
* datasets.py contains code for handling (and generating) data as used in the experiments. 
* opt_utils contains boiler-plate code for training the MLP:s using the different approaches of the paper. 
* eval_script.py is a script for evaluating results as stored by the training files.
* t train_different_groups.py are training scripts for repeating the experiments in the paper

### Required and optional libraries
The package requires the [pytorch](https://pytorch.org/) and [numpy](https://numpy.org/) packages.  [matplotlib](https://matplotlib.org/) is optional: it is only needed for the plots in eval_script.py.

## Running the experiment from the appendix
To run the additional experiment from the appendix, run train_different_groups.py with arguments augnumber nbr_experiments. 
Augnumber decides how many passes should be made over the data for the augmented run (in the experiments in the paper, these were set to 25). I.e., to run the permutation experiment as in the paper, run

```
    python  train_different_groups.py 25 30
```
 
Then, run evalscript.py with 'all_t' as first parameter and nbr_exp as second parameter to produce a figure like the one in the paper (it will be less tidy but
have the same general appearance), like:

```
   python evalscript.py all_t 30
```
The plot windows may appear on top of each other -- move them to inspect them all at once.

### Disclaimers
The experiments in the paper were performed on a cluster. Therefore, some aspects of the code, such as the training scripts, differs very slightly from the code released here. There should be no difference in performance.

Note that in particular the translation and rotation experiments will take quite some time, in particular when repeating them 30 times. The code has not been optimized in any way, and our experiments took around tens of GPU hours in total. 

The experiments will default to be performed on the data downloaded with the repository, which is the data we used. The datasets classes are made ready to generate new sets of data if you wish to do so. See further documentation in datasets.py.



